<?php

namespace App\Http\Controllers;

use App\Http\Requests\SalesmanBranchOfficeRequest;
use App\Services\SalesmanBranchOfficeService;
use App\Traits\HasResponse;
use Illuminate\Http\Request;

class SalesmanBranchOfficeController extends Controller
{
    use HasResponse;
    /** @var SalesmanBranchOfficeService */
    private $salesmanBranchOfficeService;

    public function __construct(SalesmanBranchOfficeService $salesmanBranchOfficeService)
    {
        $this->salesmanBranchOfficeService = $salesmanBranchOfficeService;
    }

    public function list(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->salesmanBranchOfficeService->list($withPagination);
    }

    public function register(SalesmanBranchOfficeRequest $request)
    {
        return $this->salesmanBranchOfficeService->register($request->validated());
    }

    public function update($id, SalesmanBranchOfficeRequest $request)
    {
        return $this->salesmanBranchOfficeService->update($id, $request->validated());
    }

    public function delete($id)
    {
        return $this->salesmanBranchOfficeService->delete($id);
    }
}
