<?php

namespace App\Http\Controllers;

use App\Http\Requests\SaleChannelRequest;
use App\Services\SaleChannelService;
use App\Traits\HasResponse;
use Illuminate\Http\Request;

class SaleChannelController extends Controller
{
    use HasResponse;

    /** @var SaleChannelService */
    private $saleChannelService;

    public function __construct(SaleChannelService $saleChannelService)
    {
        $this->saleChannelService = $saleChannelService;
    }

    public function list(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->saleChannelService->list($request->all(), $withPagination);
    }

    public function register(SaleChannelRequest $request)
    {
        return $this->saleChannelService->register($request->validated());
    }

    public function update($id, SaleChannelRequest $request)
    {
        return $this->saleChannelService->update($id, $request->validated());
    }

    public function delete($id)
    {
        return $this->saleChannelService->delete($id);
    }
}
