<?php

namespace App\Http\Controllers;

use App\Http\Requests\ReferenceDocumentsRequest;
use App\Services\ReferenceDocumentsService;
use App\Traits\HasResponse;
use Illuminate\Http\Request;

class ReferenceDocumentsController extends Controller
{
    use HasResponse;
    /** @var ReferenceDocumentsService */
    private $referenceDocumentsService;

    public function __construct(ReferenceDocumentsService $referenceDocumentsService)
    {
        $this->referenceDocumentsService = $referenceDocumentsService;
    }

    public function list(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->referenceDocumentsService->list($withPagination);
    }

    public function register(ReferenceDocumentsRequest $request)
    {
        return $this->referenceDocumentsService->register($request->validated());
    }

    public function update($id, ReferenceDocumentsRequest $request)
    {
        return $this->referenceDocumentsService->update($id, $request->validated());
    }

    public function delete($id)
    {
        return $this->referenceDocumentsService->delete($id);
    }
}
