<?php

namespace App\Http\Controllers;

use App\Http\Requests\ProofPaymentRequest;
use App\Services\ProofPaymentService;
use App\Traits\HasResponse;
use Illuminate\Http\Request;

class ProofPaymentController extends Controller
{
    use HasResponse;

    /** @var ProofPaymentService */
    private $proofPaymentService;

    public function __construct(ProofPaymentService $proofPaymentService)
    {
        $this->proofPaymentService = $proofPaymentService;
    }

    public function list(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->proofPaymentService->list($withPagination);
    }

    public function acceptDocument($id)
    {
        return $this->proofPaymentService->acceptDocument($id);
    }

    public function delete($id)
    {
        return $this->proofPaymentService->delete($id);
    }

    # PDF
    public function getPDF(ProofPaymentRequest $request)
    {
        return $this->proofPaymentService->getPDF($request->validated());
    }

    public function savePDF(ProofPaymentRequest $request)
    {
        return $this->proofPaymentService->savePDF($request->validated());
    }

    # Correo
    public function sendEmail($id, Request $request)
    {
        return $this->proofPaymentService->sendEmail($id, $request->all());
    }
}
