<?php

namespace App\Http\Controllers;

use App\Http\Requests\ProductsImportMassiveRequest;
use App\Http\Requests\ProductsImportRequest;
use App\Services\ProductsImportService;
use App\Traits\HasResponse;
use Illuminate\Http\Request;

class ProductsImportController extends Controller
{
    use HasResponse;
    /** @var ProductsImportService */
    private $productsImportService;

    public function __construct(ProductsImportService $productsImportService)
    {
        $this->productsImportService = $productsImportService;
    }

    public function list(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->productsImportService->list($withPagination);
    }

    public function update($id, ProductsImportRequest $request)
    {
        return $this->productsImportService->update($id, $request->validated());
    }

    public function validateUserImport()
    {
        return $this->productsImportService->validateUserImport();
    }

    public function import($id)
    {
        return $this->productsImportService->importProduct($id);
    }

    public function importMassive(ProductsImportMassiveRequest $request)
    {
        return $this->productsImportService->importMassive($request->validated());
    }

    public function delete($id)
    {
        return $this->productsImportService->delete($id);
    }
}
