<?php

namespace App\Http\Controllers;

use App\Http\Requests\ImportProductRequest;
use App\Http\Requests\ProductRequest;
use App\Services\ProductService;
use App\Traits\HasResponse;
use Illuminate\Http\Request;

class ProductController extends Controller
{
    use HasResponse;
    /** @var ProductService */
    private $productService;

    public function __construct(ProductService $productService)
    {
        $this->productService = $productService;
    }

    public function list(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->productService->list($withPagination, $request->all());
    }

    public function listByCompany(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->productService->listByCompany($request->all(), $withPagination);
    }

    public function register(ProductRequest $request)
    {
        return $this->productService->register($request->validated());
    }

    public function update($id, ProductRequest $request)
    {
        return $this->productService->update($id, $request->validated());
    }

    public function delete($id)
    {
        return $this->productService->delete($id);
    }

    public function downloadTemplate(Request $request)
    {
        return $this->productService->downloadTemplate($request->all());
    }

    public function importProductExcel(ImportProductRequest $request)
    {
        return $this->productService->importProductExcel($request->validated());
    }

    public function listErpProducts(Request $request)
    {
        return $this->productService->listErpProducts($request->all());
    }
}
