<?php

namespace App\Http\Controllers;

use App\Http\Requests\ProductClassificationRequest;
use App\Services\ProductClassificationService;
use App\Traits\HasResponse;
use Illuminate\Http\Request;

class ProductClassificationController extends Controller
{
    use HasResponse;

    /** @var ProductClassificationService */
    private $productClassificationService;

    public function __construct(ProductClassificationService $productClassificationService)
    {
        $this->productClassificationService = $productClassificationService;
    }

    public function list(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->productClassificationService->list($request->all(), $withPagination);
    }

    public function register(ProductClassificationRequest $request)
    {
        return $this->productClassificationService->register($request->validated());
    }

    public function update($id, ProductClassificationRequest $request)
    {
        return $this->productClassificationService->update($id, $request->validated());
    }

    public function delete($id)
    {
        return $this->productClassificationService->delete($id);
    }
}
