<?php

namespace App\Http\Controllers;

use App\Http\Requests\ProductAttributeRequest;
use App\Services\ProductAttributeService;
use App\Traits\HasResponse;
use Illuminate\Http\Request;

class ProductAttributeController extends Controller
{
    use HasResponse;
    /** @var ProductAttributeService */
    private $productAttributeService;

    public function __construct(ProductAttributeService $productAttributeService)
    {
        $this->productAttributeService = $productAttributeService;
    }
    
    public function list(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->productAttributeService->list($request->all(), $withPagination);
    }

    public function listByCompany(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->productAttributeService->listByCompany($request->all(), $withPagination);
    }

    public function register(ProductAttributeRequest $request)
    {
        return $this->productAttributeService->register($request->validated());
    }

    public function dataOptimizated(Request $request)
    {
        return $this->productAttributeService->dataOptimizated($request->all());
    }

    public function update($id, ProductAttributeRequest $request)
    {
        return $this->productAttributeService->update($id, $request->validated());
    }

    public function changeStatus($id, Request $request)
    {
        return $this->productAttributeService->changeStatus($id, $request);
    }

    public function delete($id)
    {
        return $this->productAttributeService->delete($id);
    }
}
