<?php

namespace App\Http\Controllers;

use App\Http\Requests\listProductRequest;
use App\Services\PriceListProductsService;
use App\Traits\HasResponse;
use Illuminate\Http\Request;

class PriceListProductsController extends Controller
{
    use HasResponse;
    /** @var PriceListProductsService */
    private $priceListProductsService;

    public function __construct(PriceListProductsService $priceListProductsService)
    {
        $this->priceListProductsService = $priceListProductsService;
    }

    public function list(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->priceListProductsService->list($withPagination);
    }

    public function register(Request $request)
    {
        return $this->priceListProductsService->register($request->validated());
    }

    public function update($id, Request $request)
    {
        return $this->priceListProductsService->update($id, $request->validated());
    }

    public function delete($id)
    {
        return $this->priceListProductsService->delete($id);
    }

    public function listProduct(listProductRequest $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->priceListProductsService->listProduct($request->validated(), $withPagination);
    }

    public function searchProduct(listProductRequest $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->priceListProductsService->searchProductNew($request->validated(), $withPagination);
    }
}
