<?php

namespace App\Http\Controllers;

use App\Http\Requests\PriceListRequest;
use App\Services\PriceListService;
use App\Traits\HasResponse;
use Illuminate\Http\Request;

class PriceListController extends Controller
{
    use HasResponse;
    /** @var PriceListService */
    private $priceListService;

    public function __construct(PriceListService $priceListService)
    {
        $this->priceListService = $priceListService;
    }

    public function list(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->priceListService->list($withPagination);
    }

    public function register(PriceListRequest $request)
    {
        return $this->priceListService->register($request->validated());
    }

    public function duplicate(Request $request)
    {
        return $this->priceListService->duplicate($request);
    }

    public function addProducts(Request $request)
    {
        return $this->priceListService->addProducts($request);
    }

    public function update($id, PriceListRequest $request)
    {
        return $this->priceListService->update($id, $request->validated());
    }

    public function delete($id)
    {
        return $this->priceListService->delete($id);
    }
}
