<?php

namespace App\Http\Controllers;

use App\Http\Requests\PermissionsUserRequest;
use App\Services\PermissionsUserService;
use App\Traits\HasResponse;
use Illuminate\Http\Request;

class PermissionsUserController extends Controller
{
    use HasResponse;
    /** @var PermissionsUserService */
    private $permissionsUserService;

    public function __construct(PermissionsUserService $permissionsUserService)
    {
        $this->permissionsUserService = $permissionsUserService;
    }

    public function list(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->permissionsUserService->list($withPagination);
    }

    public function register(PermissionsUserRequest $request)
    {
        return $this->permissionsUserService->register($request->validated());
    }

    public function update($id, PermissionsUserRequest $request)
    {
        return $this->permissionsUserService->update($id, $request->validated());
    }

    public function delete($id)
    {
        return $this->permissionsUserService->delete($id);
    }
}
