<?php

namespace App\Http\Controllers;

use App\Services\PermissionsService;
use App\Traits\HasResponse;
use Illuminate\Http\Request;

class PermissionsController extends Controller
{
    use HasResponse;
    /** @var PermissionsService */
    private $permissionsService;

    public function __construct(PermissionsService $permissionsService)
    {
        $this->permissionsService = $permissionsService;
    }

    public function list(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->permissionsService->list($request->all(), $withPagination);
    }
}
