<?php

namespace App\Http\Controllers;

use App\Http\Requests\MembershipCostRequest;
use App\Services\MembershipCostsService;
use App\Traits\HasResponse;
use Illuminate\Http\Request;

class MembershipCostsController extends Controller
{
    use HasResponse;
    /** @var  MembershipCostsService*/
    private $membershipCostsService;

    public function __construct(MembershipCostsService $membershipCostsService)
    {
        $this->membershipCostsService = $membershipCostsService;
    }

    public function list()
    {
        return $this->membershipCostsService->getCosts();
    }

    public function getById($id)
    {
        return $this->membershipCostsService->getCostsById($id);
    }

    public function getCostsTreatment()
    {
        return $this->membershipCostsService->getCostsTreatment();
    }

    public function getCostsAll()
    {
        return $this->membershipCostsService->getCostsAll();
    }

    public function store(MembershipCostRequest $request)
    {
        return $this->membershipCostsService->createCosts($request->validated());
    }

    public function edit($id, Request $request)
    {
        return $this->membershipCostsService->editDateCosts($id, $request->all());
    }

    public function destroy($id)
    {
        return $this->membershipCostsService->deleteCosts($id);
    }
}
