<?php

namespace App\Http\Controllers;

use App\Http\Requests\MembershipRequest;
use App\Services\MembershipService;
use App\Traits\HasResponse;
use Illuminate\Http\Request;

class MembershipController extends Controller
{
    use HasResponse;
    /** @var  MembershipService*/
    private $membershipService;

    public function __construct(MembershipService $membershipService)
    {
        $this->membershipService = $membershipService;
    }

    public function list(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->membershipService->getMembership($request->all(), $withPagination);
    }

    public function getPlans()
    {
        return $this->membershipService->getPlans();
    }

    public function store(MembershipRequest $request)
    {
        return $this->membershipService->createMembership($request->validated());
    }

    public function getMembershipProfessional(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->membershipService->getMembershipProfessional($withPagination);
    }
}
