<?php

namespace App\Http\Controllers;

use App\Http\Requests\InternalGuideRequest;
use App\Services\InternalGuideService;
use App\Traits\HasResponse;
use Illuminate\Http\Request;

class InternalGuideController extends Controller
{
    use HasResponse;
    /** @var InternalGuideService */
    private $internalGuideService;

    public function __construct(InternalGuideService $internalGuideService)
    {
        $this->internalGuideService = $internalGuideService;
    }

    public function list(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->internalGuideService->list($withPagination);
    }

    public function register(InternalGuideRequest $request)
    {
        return $this->internalGuideService->register($request->validated());
    }

    public function delete($id, Request $request)
    {
        return $this->internalGuideService->delete($id, $request->all());
    }
}
