<?php

namespace App\Http\Controllers;

use App\Http\Requests\InitialStepRequest;
use App\Services\InitialStepService;
use App\Traits\HasResponse;
use Illuminate\Http\Request;

class InitialStepController extends Controller
{
    use HasResponse;
    
    /** @var InitialStepService */
    private $initialStepService;

    public function __construct(InitialStepService $initialStepService)
    {
        $this->initialStepService = $initialStepService;
    }

    public function list(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->initialStepService->list($request->all(), $withPagination);
    }

    public function register(InitialStepRequest $request)
    {
        return $this->initialStepService->register($request->validated());
    }

    public function update($id, InitialStepRequest $request)
    {
        return $this->initialStepService->update($id, $request->validated());
    }

    public function delete($id)
    {
        return $this->initialStepService->delete($id);
    }

    public function listDetail(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->initialStepService->listDetail($request->all(), $withPagination);
    }

    public function changeOrder(Request $request)
    {
        return $this->initialStepService->changeOrder($request->all());
    }
}
