<?php

namespace App\Http\Controllers;

use App\Http\Requests\ImportRequest;
use App\Http\Requests\ImportUpdateRequest;
use App\Services\ImportService;
use App\Traits\HasResponse;
use Illuminate\Http\Request;

class ImportController extends Controller
{
    use HasResponse;

    /** @var ImportService */
    private $importService;

    public function __construct(ImportService $importService)
    {
        $this->importService = $importService;
    }

    public function list(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->importService->list($request->all(), $withPagination);
    }

    public function register(ImportRequest $request)
    {
        return $this->importService->register($request->validated());
    }

    public function update($id, ImportUpdateRequest $request)
    {
        return $this->importService->update($id, $request->validated());
    }

    public function delete($id)
    {
        return $this->importService->delete($id);
    }

    public function downloadTemplate($id)
    {
        return $this->importService->downloadTemplate($id);
    }
}
