<?php

namespace App\Http\Controllers;

use App\Services\DocumentOfSalesService;
use App\Traits\HasResponse;
use Illuminate\Http\Request;

class DocumentOfSalesController extends Controller
{
    use HasResponse;
    /** @var DocumentOfSalesService */
    private $documentOfSalesService;

    public function __construct(DocumentOfSalesService $documentOfSalesService)
    {
        $this->documentOfSalesService = $documentOfSalesService;
    }
    
    public function list(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->documentOfSalesService->list($request->all(), $withPagination);
    }

    public function listByCompany(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->documentOfSalesService->listByCompany($request->all(), $withPagination);
    }
}
