<?php

namespace App\Http\Controllers;

use App\Http\Requests\DetailPriceListSegmentRequest;
use App\Services\DetailPriceListSegmentService;
use App\Traits\HasResponse;
use Illuminate\Http\Request;

class DetailPriceListSegmentController extends Controller
{
    use HasResponse;
    /** @var DetailPriceListSegmentService */
    private $detailPriceListSegmentService;

    public function __construct(DetailPriceListSegmentService $detailPriceListSegmentService)
    {
        $this->detailPriceListSegmentService = $detailPriceListSegmentService;
    }

    public function list(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->detailPriceListSegmentService->list($withPagination);
    }

    public function register(DetailPriceListSegmentRequest $request)
    {
        return $this->detailPriceListSegmentService->register($request->validated());
    }

    public function update($id, DetailPriceListSegmentRequest $request)
    {
        return $this->detailPriceListSegmentService->update($id, $request->validated());
    }

    public function delete($id)
    {
        return $this->detailPriceListSegmentService->delete($id);
    }
}
