<?php

namespace App\Http\Controllers;

use App\Http\Requests\DetailPriceListSalesmanRequest;
use App\Services\DetailPriceListSalesmanService;
use App\Traits\HasResponse;
use Illuminate\Http\Request;

class DetailPriceListSalesmanController extends Controller
{
    use HasResponse;
    /** @var DetailPriceListSalesmanService */
    private $detailPriceListSalesmanService;

    public function __construct(DetailPriceListSalesmanService $detailPriceListSalesmanService)
    {
        $this->detailPriceListSalesmanService = $detailPriceListSalesmanService;
    }

    public function list(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->detailPriceListSalesmanService->list($withPagination);
    }

    public function register(DetailPriceListSalesmanRequest $request)
    {
        return $this->detailPriceListSalesmanService->register($request->validated());
    }

    public function update($id, DetailPriceListSalesmanRequest $request)
    {
        return $this->detailPriceListSalesmanService->update($id, $request->validated());
    }

    public function delete($id)
    {
        return $this->detailPriceListSalesmanService->delete($id);
    }
}
