<?php

namespace App\Http\Controllers;

use App\Http\Requests\DetailPriceListCustomerRequest;
use App\Services\DetailPriceListCustomerService;
use App\Traits\HasResponse;
use Illuminate\Http\Request;

class DetailPriceListCustomerController extends Controller
{
    use HasResponse;
    /** @var DetailPriceListCustomerService */
    private $detailPriceListCustomerService;

    public function __construct(DetailPriceListCustomerService $detailPriceListCustomerService)
    {
        $this->detailPriceListCustomerService = $detailPriceListCustomerService;
    }

    public function list(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->detailPriceListCustomerService->list($withPagination);
    }

    public function register(DetailPriceListCustomerRequest $request)
    {
        return $this->detailPriceListCustomerService->register($request->validated());
    }

    public function update($id, DetailPriceListCustomerRequest $request)
    {
        return $this->detailPriceListCustomerService->update($id, $request->validated());
    }

    public function delete($id)
    {
        return $this->detailPriceListCustomerService->delete($id);
    }
}
