<?php

namespace App\Http\Controllers;

use App\Http\Requests\DetailPriceListBranchOfficeRequest;
use App\Services\DetailPriceListBranchOfficeService;
use App\Traits\HasResponse;
use Illuminate\Http\Request;

class DetailPriceListBranchOfficeController extends Controller
{
    use HasResponse;
    /** @var DetailPriceListBranchOfficeService */
    private $detailPriceListBranchOfficeService;

    public function __construct(DetailPriceListBranchOfficeService $detailPriceListBranchOfficeService)
    {
        $this->detailPriceListBranchOfficeService = $detailPriceListBranchOfficeService;
    }

    public function list(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->detailPriceListBranchOfficeService->list($withPagination);
    }

    public function register(DetailPriceListBranchOfficeRequest $request)
    {
        return $this->detailPriceListBranchOfficeService->register($request->validated());
    }

    public function update($id, DetailPriceListBranchOfficeRequest $request)
    {
        return $this->detailPriceListBranchOfficeService->update($id, $request->validated());
    }

    public function delete($id)
    {
        return $this->detailPriceListBranchOfficeService->delete($id);
    }
}
