<?php

namespace App\Http\Controllers;

use App\Http\Requests\DetailMembershipPaymentRequest;
use App\Services\DetailMembershipPaymentService;
use App\Traits\HasResponse;
use Illuminate\Http\Request;

class DetailMembershipPaymentController extends Controller
{
    use HasResponse;
    /** @var DetailMembershipPaymentService */
    private $detailMembershipPaymentService;

    public function __construct(DetailMembershipPaymentService $detailMembershipPaymentService)
    {
        $this->detailMembershipPaymentService = $detailMembershipPaymentService;
    }

    public function list(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->detailMembershipPaymentService->getMembershipPayment($withPagination);
    }

    public function store(DetailMembershipPaymentRequest $request)
    {
        return $this->detailMembershipPaymentService->createMembershipPayment($request->validated());
    }

    public function getPaymentsByIdMembership(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->detailMembershipPaymentService->getPaymentsByIdMembership($request->all(), $withPagination);
    }

    public function getPaymentMembershipByCompany($id, Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->detailMembershipPaymentService->getPaymentsByIdMembership($id, $withPagination);
    }

    public function getCompanysWithMembershipExpired(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->detailMembershipPaymentService->getCompanysWithMembershipExpired($request->all(), $withPagination);
    }

    public function sendMailMembershipExpired($id)
    {
        return $this->detailMembershipPaymentService->sendMailMembershipExpired($id);
    }
}
