<?php

namespace App\Http\Controllers;

use App\Http\Requests\CustomerWalletRequest;
use App\Services\CustomerWalletService;
use App\Traits\HasResponse;
use Illuminate\Http\Request;

class CustomerWalletController extends Controller
{
    use HasResponse;
    /** @var CustomerWalletService */
    private $customerWalletService;

    public function __construct(CustomerWalletService $customerWalletService)
    {
        $this->customerWalletService = $customerWalletService;
    }

    public function list(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->customerWalletService->list($withPagination);
    }

    public function register(CustomerWalletRequest $request)
    {
        return $this->customerWalletService->register($request->validated());
    }

    public function update($id, CustomerWalletRequest $request)
    {
        return $this->customerWalletService->update($id, $request->validated());
    }

    public function delete($id)
    {
        return $this->customerWalletService->delete($id);
    }
}
