<?php

namespace App\Http\Controllers;

use App\Http\Requests\CompanyDefaultPermissionsRequest;
use App\Services\CompanyDefaultPermissionsServirce;
use App\Traits\HasResponse;
use Illuminate\Http\Request;

class CompanyDefaultPermissionsController extends Controller
{
    use HasResponse;
    /** @var CompanyDefaultPermissionsServirce */
    private $companyDefaultPermissionsServirce;

    public function __construct(CompanyDefaultPermissionsServirce $companyDefaultPermissionsServirce)
    {
        $this->companyDefaultPermissionsServirce = $companyDefaultPermissionsServirce;
    }

    public function list(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->companyDefaultPermissionsServirce->list($withPagination);
    }

    public function update($id, CompanyDefaultPermissionsRequest $request)
    {
        return $this->companyDefaultPermissionsServirce->update($id, $request->validated());
    }

}
