<?php

namespace App\Http\Controllers;

use App\Http\Requests\CompanyCreateRequest;
use App\Http\Requests\CompanyListRequest;
use App\Http\Requests\CompanyUpdateRequest;
use App\Services\CompanyService;
use App\Traits\HasResponse;
use Illuminate\Http\Request;

class CompanyController extends Controller
{
    use HasResponse;
    /** @var CompanyService */
    private $companyService;

    public function __construct(CompanyService $companyService)
    {
        $this->companyService = $companyService;
    }

    public function list(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->companyService->list($withPagination);
    }

    public function register(CompanyCreateRequest $request)
    {
        return $this->companyService->register($request->validated());
    }

    public function update($id, CompanyUpdateRequest $request)
    {
        return $this->companyService->update($id, $request->validated());
    }

    public function delete($id)
    {
        return $this->companyService->delete($id);
    }
}
