<?php

namespace App\Http\Controllers;

use App\Http\Requests\CompanyConfigurationRequest;
use App\Services\CompanyConfigurationService;
use App\Traits\HasResponse;
use Illuminate\Http\Request;

class CompanyConfigurationController extends Controller
{
    use HasResponse;
    /** @var CompanyConfigurationService */
    private $companyConfigurationService;

    public function __construct(CompanyConfigurationService $companyConfigurationService)
    {
        $this->companyConfigurationService = $companyConfigurationService;
    }

    public function list(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->companyConfigurationService->list($withPagination);
    }

    public function update(CompanyConfigurationRequest $request)
    {
        return $this->companyConfigurationService->update($request->validated());
    }
}
