<?php

namespace App\Http\Controllers;

use App\Http\Requests\ClientAddressRequest;
use App\Services\ClientAddressService;
use App\Traits\HasResponse;
use Illuminate\Http\Request;

class ClientAddressController extends Controller
{
    use HasResponse;
    
    /** @var ClientAddressService */
    private $clientAddressService;

    public function __construct(ClientAddressService $clientAddressService)
    {
        $this->clientAddressService = $clientAddressService;
    }

    public function list(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->clientAddressService->list($request->all(), $withPagination);
    }

    public function register(ClientAddressRequest $request)
    {
        return $this->clientAddressService->register($request->validated());
    }

    public function update($id, ClientAddressRequest $request)
    {
        return $this->clientAddressService->update($id, $request->validated());
    }

    public function delete($id)
    {
        return $this->clientAddressService->delete($id);
    }
}
