<?php

namespace App\Http\Controllers;

use App\Http\Requests\CategoryRequest;
use App\Services\CategoryService;
use App\Traits\HasResponse;
use Illuminate\Http\Request;

class CategoryController extends Controller
{
    use HasResponse;
    /** @var CategoryService */
    private $categoryService;

    public function __construct(CategoryService $categoryService)
    {
        $this->categoryService = $categoryService;
    }
    
    public function list(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->categoryService->list($request->all(), $withPagination);
    }

    public function listByCompany(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->categoryService->listByCompany($request->all(), $withPagination);
    }

    public function listDuplicated(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->categoryService->listDuplicated($request->all(), $withPagination);
    }

    public function listWithProducts(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->categoryService->listWithProducts($request->all(), $withPagination);
    }

    public function register(CategoryRequest $request)
    {
        return $this->categoryService->register($request->validated());
    }

    public function unifyDuplicated(Request $request)
    {
        return $this->categoryService->unifyDuplicated($request->all());
    }

    public function reviewData(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->categoryService->reviewData($request->all(), $withPagination);
    }

    public function update($id, CategoryRequest $request)
    {
        return $this->categoryService->update($id, $request->validated());
    }

    public function delete($id)
    {
        return $this->categoryService->delete($id);
    }
}
