<?php

namespace App\Http\Controllers;

use App\Http\Requests\BusinessAreaRequest;
use App\Services\BusinessAreaService;
use App\Traits\HasResponse;
use Illuminate\Http\Request;

class BusinessAreaController extends Controller
{
    use HasResponse;
    /** @var BusinessAreaService */
    private $businessAreaService;

    public function __construct(BusinessAreaService $businessAreaService)
    {
        $this->businessAreaService = $businessAreaService;
    }

    public function list(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->businessAreaService->list($withPagination);
    }

    public function register(BusinessAreaRequest $request)
    {
        return $this->businessAreaService->register($request->validated());
    }

    public function update($id, BusinessAreaRequest $request)
    {
        return $this->businessAreaService->update($id, $request->validated());
    }

    public function changeStatus($id, Request $request)
    {
        return $this->businessAreaService->changeStatus($id, $request);
    }

    public function delete($id)
    {
        return $this->businessAreaService->delete($id);
    }
}
