<?php

namespace App\Http\Controllers;

use App\Http\Requests\BranchOfficeRequest;
use App\Services\BranchOfficeService;
use App\Traits\HasResponse;
use Illuminate\Http\Request;

class BranchOfficeController extends Controller
{
    use HasResponse;
    /** @var BranchOfficeService */
    private $branchOfficeService;

    public function __construct(BranchOfficeService $branchOfficeService)
    {
        $this->branchOfficeService = $branchOfficeService;
    }
    
    public function list(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->branchOfficeService->list($request->all(), $withPagination);
    }

    public function listByCompany(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->branchOfficeService->listByCompany($request->all(), $withPagination);
    }

    public function listTypesBranches(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->branchOfficeService->listTypesBranches($withPagination);
    }

    public function register(BranchOfficeRequest $request)
    {
        return $this->branchOfficeService->register($request->validated());
    }

    public function update($id, BranchOfficeRequest $request)
    {
        return $this->branchOfficeService->update($id, $request->validated());
    }

    public function delete($id)
    {
        return $this->branchOfficeService->delete($id);
    }
}
