<?php

namespace App\Http\Controllers;

use App\Services\BankService;
use App\Traits\HasResponse;
use Illuminate\Http\Request;

class BankController extends Controller
{
    use HasResponse;

    /** @var BankService */
    private $bankService;

    public function __construct(BankService $bankService)
    {
        $this->bankService = $bankService;
    }

    public function list(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->bankService->list($withPagination);
    }
}
