<?php

namespace App\Http\Controllers;

use App\Http\Requests\AdminCompanyRequest;
use App\Services\AdminCompanyService;
use App\Traits\HasResponse;
use Illuminate\Http\Request;

class AdminCompanyController extends Controller
{
    use HasResponse;
    /** @var AdminCompanyService */
    private $adminCompanyService;

    public function __construct(AdminCompanyService $adminCompanyService)
    {
        $this->adminCompanyService = $adminCompanyService;
    }

    public function list(Request $request)
    {
        $withPagination = $this->validatePagination($request->only('perPage', 'page'));
        return $this->adminCompanyService->list($withPagination);
    }

    public function register(AdminCompanyRequest $request)
    {
        return $this->adminCompanyService->register($request->validated());
    }

    public function update($id, AdminCompanyRequest $request)
    {
        return $this->adminCompanyService->update($id, $request->validated());
    }

    public function delete($id)
    {
        return $this->adminCompanyService->delete($id);
    }
}
