<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithStrictNullComparison;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class ProductsTemplateNotInvetoryExport implements WithStyles, FromCollection, WithHeadings, WithStrictNullComparison, ShouldAutoSize
{

    # Encabezados iniciales del archivo excel
    public function headings(): array
    {
        return [
            'CODIGO',
            'NOMBRE',
            'DESCRIPCION',
            'COSTO',
            'PRECIO',
            'CATEGORIA',
            'PROVEEDOR',
            'UNIDAD DE MEDIDA',
        ];
    }

    # Adición de estilos para ciertas columnas
    public function styles(Worksheet $sheet)
    {
        $sheet->getStyle('A1:H1')->getFill()->applyFromArray(['fillType' => 'solid', 'rotation' => 0, 'color' => ['rgb' => 'E26808'],]);
        return [
            1    => [
                'font' => [
                    'bold' => true
                ],
            ],
        ];
    }

    # Recibe la data enviada desde el uso de la clase
    public function __construct($data)
    {
        $this->data = $data;
    }

    # Brinda la data con las adiciones de la clase para generar el archivo excel
    public function collection()
    {
        return collect($this->data);
    }
}
