<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithStrictNullComparison;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class ProductsTemplateExport implements WithStyles, FromCollection, WithHeadings, WithStrictNullComparison, ShouldAutoSize
{

    # Encabezados iniciales del archivo excel
    public function headings(): array
    {
        return [
            'CODIGO',
            // 'barcode',
            'NOMBRE',
            'DESCRIPCION',
            'STOCK',
            'BODEGA',
            'COSTO',
            'PRECIO',
            // 'PRECIO ALTERNATIVO',
            // 'MARGEN',
            // 'PRECIO DE OFERTA',
            // 'STOCK MINIMO',
            // 'STOCK MAXIMO',
            // 'TIPO DE MONEDA',
            'CATEGORIA',
            // 'SUBCATEGORIA',
            // 'SUBCATEGORIA ESPECIFICA',
            // 'TIPO DE PRODUCTO',
            'PROVEEDOR',
            'UNIDAD DE MEDIDA',
            // 'UNIDAD DE MEDIDA OPCIONAL',
            // 'AREA DE NEGOCIO',
            // 'CLASIFICACION'
        ];
    }

    # Adición de estilos para ciertas columnas
    public function styles(Worksheet $sheet)
    {
        $sheet->getStyle('A1:J1')->getFill()->applyFromArray(['fillType' => 'solid', 'rotation' => 0, 'color' => ['rgb' => 'E26808'],]);
        return [
            1    => [
                'font' => [
                    'bold' => true
                ],
            ],
        ];
    }

    # Recibe la data enviada desde el uso de la clase
    public function __construct($data)
    {
        $this->data = $data;
    }

    # Brinda la data con las adiciones de la clase para generar el archivo excel
    public function collection()
    {
        return collect($this->data);
    }
}
