<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    protected function schedule(Schedule $schedule): void
    {
        $schedule->command('update:priceMembership');           #->dailyAt('08:00');
        $schedule->command('membership:expired');               #->dailyAt('13:00');
        $schedule->command('membership:change');                #->dailyAt('13:00');
        $schedule->command('expiration:proofPaymentForAdmin');  #->dailyAt('13:00');
        $schedule->command('expiration:proofPaymentForUser');   #->dailyAt('06:00');
    }

    protected function commands(): void
    {
        $this->load(__DIR__ . '/Commands');

        require base_path('routes/console.php');
    }
}
