<?php

namespace App\Console\Commands;

use App\Models\MembershipCosts;
use GuzzleHttp\Client;
use Illuminate\Console\Command;

class UpdatePriceOfMembership extends Command
{
    protected $signature = 'update:priceMembership';

    protected $description = 'Actualizar los precios de las membresías de acuerdo al precio actual del UF';

    public function handle()
    {
        #Lectura de la API de UF actual
        $client = new Client();
        $response = $client->request('GET', 'https://api.santa.cl/uf');

        $body = $response->getBody();
        $uf = json_decode($body, true);
        if (isset($uf['uf'])) {
            $uf = $uf['uf'];

            #Precios de plan basic, standar y pro
            $price_monthly_basic    =   $uf * MembershipCosts::find(1)->UF;
            $price_biannual_basic   =   $uf * MembershipCosts::find(2)->UF;
            $price_yearly_basic     =   $uf * MembershipCosts::find(3)->UF;

            $price_monthly_standar  =   $uf * MembershipCosts::find(4)->UF;
            $price_biannual_standar =   $uf * MembershipCosts::find(5)->UF;
            $price_yearly_standar   =   $uf * MembershipCosts::find(6)->UF;

            $price_monthly_pro      =   $uf * MembershipCosts::find(7)->UF;
            $price_biannual_pro     =   $uf * MembershipCosts::find(8)->UF;
            $price_yearly_pro       =   $uf * MembershipCosts::find(9)->UF;

            #Actualizar registros
            MembershipCosts::where('id', 1)->update(['amount' => $price_monthly_basic]);
            MembershipCosts::where('id', 2)->update(['amount' => $price_biannual_basic]);
            MembershipCosts::where('id', 3)->update(['amount' => $price_yearly_basic]);

            MembershipCosts::where('id', 4)->update(['amount' => $price_monthly_standar]);
            MembershipCosts::where('id', 5)->update(['amount' => $price_biannual_standar]);
            MembershipCosts::where('id', 6)->update(['amount' => $price_yearly_standar]);

            MembershipCosts::where('id', 7)->update(['amount' => $price_monthly_pro]);
            MembershipCosts::where('id', 8)->update(['amount' => $price_biannual_pro]);
            MembershipCosts::where('id', 9)->update(['amount' => $price_yearly_pro]);
        }
    }
}
