<?php

namespace App\Console\Commands;

use App\Mail\MembershipChangeDefeatedMail;
use App\Models\Company;
use App\Models\DetailMembershipPayment;
use App\Models\Url;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Mail;

class ReminderMembershipChangeEvent extends Command
{
    protected $signature = 'membership:change';

    protected $description = 'Cambio de membresia Deudor';

    public function handle()
    {
        # 3 días despues de la expiracion
        $dateAfter = Carbon::now()->subDays(3)->toDateString();
        $expiratonAfter = DetailMembershipPayment::whereDate('payment_date_end', $dateAfter)
            ->where('status', 1)->where('status_page', 1)->distinct()->pluck('idcompany');

        #Actualizar tipo de membresía de la compañía
        Company::whereIn('id', $expiratonAfter)->where('status', 1)->update(['idmembership' => 4]);

        #Actualizar estado su pago
        DetailMembershipPayment::whereDate('payment_date_end', $dateAfter)
            ->where('status', 1)->where('status_page', 1)->update(['status_page' => 2]);


        $webActiveMembership = Url::find(2)->url . '/login';

        #Mandar correo a la cuenta acaba de ser cambiada a vencida
        foreach ($expiratonAfter as $key => $value) {
            $idcompany = $value;

            #Datos para el correo
            $admin = User::where('idcompany', $idcompany)->active()
                ->whereHas('detailUser', function ($q) use ($idcompany) {
                    $q->where('iduser_type', 2)->where('idcompany', $idcompany)->active();
                })->first();

            #Enviar correo al usuario correspondiente para decirle que su membresía a sido marcada como vencida
            Mail::to($admin->email)->send(new MembershipChangeDefeatedMail(
                "$admin->username",     # Nombre del administrador
                $webActiveMembership,   # URL de reactivacion
            ));
        }
    }
}
