<?php

namespace App\Console\Commands;

use App\Mail\ProofPaymentMail;
use App\Models\AdminCompany;
use App\Models\DetailUserCompany;
use App\Models\ProofPayment;
use App\Models\Salesman;
use App\Models\Supplier;
use App\Traits\HasResponse;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;

class ExpiratonProofPaymentForUserCommand extends Command
{
    use HasResponse;

    protected $signature = 'expiration:proofPaymentForUser';

    protected $description = 'Command description';

    public function handle()
    {
        // Buscar todos los comprobantes de pago activos, que son al crédito, vencen este día y no han sido aceptados por un usuario
        $proofPayments = ProofPayment::where('payment_method', 2)
            ->whereDate('expiration', now()->toDateString())
            ->whereNull('accepted_iduser')
            ->active()->get();

        foreach ($proofPayments as $proofPayment) $this->mailSendingMethod($proofPayment);
    }

    private function mailSendingMethod($proofPayment)
    {
        try {
            DB::beginTransaction();
            $user = DetailUserCompany::where('iduser', $proofPayment->userCreated->id)
                ->active()->first();
            if (!$user) return $this->errorResponse('El usuario no cuenta con información válida.', 400);

            Mail::to($proofPayment->userCreated->email)->send(
                new ProofPaymentMail(
                    $this->dataUser($proofPayment->userCreated->rut, $user->iduser_type)['name'],
                    $proofPayment->id,
                    Carbon::parse($proofPayment->expiration)->isoFormat('D [de] MMMM [de] YYYY'),
                    $proofPayment->amount_text
                )
            );
            $proofPayment->update(['expiration_email' => 1]);
            DB::commit();
            return $this->successResponse('OK');
        } catch (\Throwable $th) {
            DB::rollBack();
            return $this->successResponse('OK');
        }
    }

    private function dataUser($rut, $typeUser)
    {

        switch ($typeUser) {
            case '1':
                # Superadministrador
                $name = 'Superadministrador';
                $rut = '00000000-0';
                $phone = '999999999';

                break;

            case '2':
                # Administrador
                $infoUser = AdminCompany::where('rut', $rut)->company()->first();
                $name = $infoUser->name ?? 'Nombre no disponible';
                $rut = $infoUser->rut ?? '00000000-0';
                $phone = $infoUser->phone ?? '999999999';
                break;

            case '3':
                # Vendedor
                $infoUser = Salesman::where('rut', $rut)->company()->first();
                $name = $infoUser->name ?? 'Nombre no disponible';
                $rut = $infoUser->rut ?? '00000000-0';
                $phone = $infoUser->phone ?? '999999999';
                break;

            case '4':
                # Proveedor
                $infoUser = Supplier::where('rut', $rut)->company()->first();
                $name = $infoUser->name_rz ?? 'Nombre no disponible';
                $rut = $infoUser->rut ?? '00000000-0';
                $phone = $infoUser->phone ?? '999999999';
                break;

            case '5':
                # Cliente
                $infoUser = Supplier::where('rut', $rut)->company()->first();
                if (!$infoUser) {
                    $salesman = true;
                    $infoUser = Salesman::where('rut', $rut)->company()->first();
                }
                $name = ($salesman ? $infoUser->name : $infoUser->name_rz) ?? 'Nombre no disponible';
                $rut = $infoUser->rut ?? '00000000-0';
                $phone = $infoUser->phone ?? '999999999';
                break;

            default:
                # code...
                break;
        }

        return [
            'name'  => $name ?? 'Nombre no disponible',
            'rut'   => $rut ?? '00000000-0',
            'phone' => $phone ?? '999999999',
        ];
    }
}
